#ifndef __PROFIBUS_MPI_ERROR_H
#define __PROFIBUS_MPI_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS MPI ERROR codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_MPI_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_MPI_COMMAND_INVALID ((TLR_RESULT)0xC0670001L)

//
// MessageId: TLR_E_PROFIBUS_MPI_INVALID_PACKET_LENGTH
//
// MessageText:
//
//  Invalid packet length received.
//
#define TLR_E_PROFIBUS_MPI_INVALID_PACKET_LENGTH ((TLR_RESULT)0xC0670002L)

//
// MessageId: TLR_E_PROFIBUS_DATA_CNT
//
// MessageText:
//
//  Data Counter Error.
//
#define TLR_E_PROFIBUS_DATA_CNT          ((TLR_RESULT)0xC0670005L)

//
// MessageId: TLR_E_PROFIBUS_MPI_ILLEGAL_STATION_ADDRESS
//
// MessageText:
//
//  Station Address is invalid.
//
#define TLR_E_PROFIBUS_MPI_ILLEGAL_STATION_ADDRESS ((TLR_RESULT)0xC0670006L)

//
// MessageId: TLR_E_PROFIBUS_MPI_ILLEGAL_SOCKET_NUMBER
//
// MessageText:
//
//  Socket number is invalid.
//
#define TLR_E_PROFIBUS_MPI_ILLEGAL_SOCKET_NUMBER ((TLR_RESULT)0xC0670007L)

//
// MessageId: TLR_E_PROFIBUS_MPI_COMMUNICATION_ABORTED
//
// MessageText:
//
//  Communcation is aborted by the remote station.
//
#define TLR_E_PROFIBUS_MPI_COMMUNICATION_ABORTED ((TLR_RESULT)0xC0670008L)

//
// MessageId: TLR_E_PROFIBUS_MPI_COMMUNICATION_REFUSED
//
// MessageText:
//
//  Communcation is refused by the remote station.
//
#define TLR_E_PROFIBUS_MPI_COMMUNICATION_REFUSED ((TLR_RESULT)0xC0670009L)

//
// MessageId: TLR_E_PROFIBUS_MPI_ERROR_WHILE_BARGAIN_LEN
//
// MessageText:
//
//  Communcation error while bargain max data len.
//
#define TLR_E_PROFIBUS_MPI_ERROR_WHILE_BARGAIN_LEN ((TLR_RESULT)0xC067000AL)

//
// MessageId: TLR_E_PROFIBUS_MPI_DATA_OUT_OF_ORDER
//
// MessageText:
//
//  Recived packet has wrong sequence number.
//
#define TLR_E_PROFIBUS_MPI_DATA_OUT_OF_ORDER ((TLR_RESULT)0xC067000BL)

//
// MessageId: TLR_E_PROFIBUS_MPI_DISCONNECT_REQUEST
//
// MessageText:
//
//  Host application has send an disconnect request.
//
#define TLR_E_PROFIBUS_MPI_DISCONNECT_REQUEST ((TLR_RESULT)0xC067000CL)

//
// MessageId: TLR_E_PROFIBUS_MPI_CON_TO
//
// MessageText:
//
//  Timeout.
//
#define TLR_E_PROFIBUS_MPI_CON_TO        ((TLR_RESULT)0xC0670130L)

//
// MessageId: TLR_E_PROFIBUS_MPI_CON_SE
//
// MessageText:
//
//  Sequenceerror.
//
#define TLR_E_PROFIBUS_MPI_CON_SE        ((TLR_RESULT)0xC0670139L)

//
// MessageId: TLR_E_PROFIBUS_MPI_BUS_UNCONFIGURED
//
// MessageText:
//
//  Bus unconfigured.
//
#define TLR_E_PROFIBUS_MPI_BUS_UNCONFIGURED ((TLR_RESULT)0xC0670202L)

//
// MessageId: TLR_E_PROFIBUS_MPI_ILLEGAL_FUNCTION_NUMBER
//
// MessageText:
//
//  Illegalfunction number.
//
#define TLR_E_PROFIBUS_MPI_ILLEGAL_FUNCTION_NUMBER ((TLR_RESULT)0xC0670203L)

//
// MessageId: TLR_E_PROFIBUS_MPI_RESET_IN_PROGRESS
//
// MessageText:
//
//  Reset in progress.
//
#define TLR_E_PROFIBUS_MPI_RESET_IN_PROGRESS ((TLR_RESULT)0xC0670204L)

//
// MessageId: TLR_E_PROFIBUS_MPI_TOO_MANY_REQ_IN_PROGRESS
//
// MessageText:
//
//  Too many requests in progress.
//
#define TLR_E_PROFIBUS_MPI_TOO_MANY_REQ_IN_PROGRESS ((TLR_RESULT)0xC0670205L)

//
// MessageId: TLR_E_PROFIBUS_MPI_DENIED_BY_WATCHDOG_TO
//
// MessageText:
//
//  No Access because of Watchdog Timeout.
//
#define TLR_E_PROFIBUS_MPI_DENIED_BY_WATCHDOG_TO ((TLR_RESULT)0xC0670206L)

//
// MessageId: TLR_E_PROFIBUS_MPI_ILLEGAL_WATCHDOG_TIME
//
// MessageText:
//
//  Illegal Watchdog time.
//
#define TLR_E_PROFIBUS_MPI_ILLEGAL_WATCHDOG_TIME ((TLR_RESULT)0xC0670207L)

//
// MessageId: TLR_E_PROFIBUS_MPI_CON_IN_PROGRESS
//
// MessageText:
//
//  Connection to Plc in progress.
//
#define TLR_E_PROFIBUS_MPI_CON_IN_PROGRESS ((TLR_RESULT)0xC0670208L)

//
// MessageId: TLR_E_PROFIBUS_MPI_BUS_ALREADY_CONFIGURED
//
// MessageText:
//
//  Bus already configured.
//
#define TLR_E_PROFIBUS_MPI_BUS_ALREADY_CONFIGURED ((TLR_RESULT)0xC0670209L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_SE
//
// MessageText:
//
//  Device stopped communication or is not in Open State.
//
#define TLR_E_PROFIBUS_MPI_REJ_SE        ((TLR_RESULT)0xC0670281L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_ABORT
//
// MessageText:
//
//  Device aborts communication.
//
#define TLR_E_PROFIBUS_MPI_REJ_ABORT     ((TLR_RESULT)0xC0670282L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_PS
//
// MessageText:
//
//  Previous Service still in Progress
//
#define TLR_E_PROFIBUS_MPI_REJ_PS        ((TLR_RESULT)0xC0670283L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_LE
//
// MessageText:
//
//  Length Error.
//
#define TLR_E_PROFIBUS_MPI_REJ_LE        ((TLR_RESULT)0xC0670284L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_IV
//
// MessageText:
//
//  Specified offset out of limits or not known to remote station.
//
#define TLR_E_PROFIBUS_MPI_REJ_IV        ((TLR_RESULT)0xC0670285L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_PDU
//
// MessageText:
//
//  Wrong PDU coding.
//
#define TLR_E_PROFIBUS_MPI_REJ_PDU       ((TLR_RESULT)0xC0670286L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_OP
//
// MessageText:
//
//  Specified Length to read or write out of limits.
//
#define TLR_E_PROFIBUS_MPI_REJ_OP        ((TLR_RESULT)0xC0670287L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_HW
//
// MessageText:
//
//  Specified address not defined in remote station.
//
#define TLR_E_PROFIBUS_MPI_REJ_HW        ((TLR_RESULT)0xC0670288L)

//
// MessageId: TLR_E_PROFIBUS_MPI_REJ_MODE
//
// MessageText:
//
//  Remote station not in right operational Mode.
//
#define TLR_E_PROFIBUS_MPI_REJ_MODE      ((TLR_RESULT)0xC0670289L)

//
// MessageId: TLR_E_PROFIBUS_MPI_UNKNOWN_ERROR
//
// MessageText:
//
//  Unknown error.
//
#define TLR_E_PROFIBUS_MPI_UNKNOWN_ERROR ((TLR_RESULT)0xC0670290L)




#endif  //__PROFIBUS_MPI_ERROR_H

